/*
//  00000000	0x00	WHITE (GREEN + BLUE + RED)
//  00000001	0x01	CYAN (GREEN + BLUE)
//  00000010	0x02	PURPLE (BLUE + RED)
//	00000011	0x03	BLUE
// 	00000100	0x04	YELLOW (GREEN + RED)
//	00000101	0x05	GREEN
//  00000110	0x06	RED
//	00000111	0x07	OFF
*/
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/pgmspace.h>

//Linear Scale Display

volatile uint16_t curadc=0;
//instantaneous adc value

volatile uint8_t LEDcolor=0;
// which color led to be lit up

SIGNAL (SIG_OVERFLOW0)
{
	TCNT0 = -1;  //  9875 Hz
//	TCNT0 = -3;  //  3125 Hz
//	TCNT0 = -5;  //  1875 Hz
//  TCNT0 - Timer/Counter Register

	switch (LEDcolor) {
		case 0:		PORTB=0x07;		//  off
					break;
		case 1:		PORTB=0x06;		//  red
					break;
		case 2:		PORTB=0x04;		//  yellow
					break;
		case 3:		PORTB=0x05;		//  green
					break;
		case 4:		PORTB=0x01;		//  cyan
					break;
		case 5:		PORTB=0x03;		//  blue
					break;
		case 6:		PORTB=0x02;		//  purple
					break;
		case 7:		PORTB=0x00;		//  white
					break;
		default:	PORTB=0x00;		//  white
					break;
	}

	ADCSRA = 0b11001111; // start conversion
}



SIGNAL (SIG_ADC)
{
	curadc=ADC;
	if(curadc >= 720) {
//	if(curadc >= 715) {				//  65F
		LEDcolor=7;		//  white
		return;
	}
	else if(curadc >= 712) {
//	else if(curadc >= 710) {		//  70F
		LEDcolor=6;		//  purple
		return;
	}
	else if(curadc >= 704) {
//	else if(curadc >= 705) {		//  72F
		LEDcolor=4;		//  cyan
//		LEDcolor=5;		//  blue
		return;
	}
	else if(curadc >= 698) {
//	else if(curadc >= 700) {		//  76F
		LEDcolor=5;		//  blue
//		LEDcolor=4;		//  cyan
		return;
	}
	else if(curadc >= 693) {
//	else if(curadc >= 695) {		//  81F
		LEDcolor=3;		//  green
		return;
	}
	else if(curadc >= 688) {
//	else if(curadc >= 690) {		//  85F
		LEDcolor=2;		//  yellow
		return;
	}
	else if(curadc >= 680) {
//	else if(curadc >= 685) {		//  92F
		LEDcolor=1;		//  red
		return;
	}
	else {
		LEDcolor=0;		//  off
		return;
	}
	
}


int main(void)
{
	PORTB = 0x07;			//  00000111
	DDRB = 0x07;			//  00000111

	TIMSK0 = 0b00000010;	//  Timer/Counter0 Overflow Interrupt Enable is set
//  TIMSK0 - Timer/Counter Interrupt Mask Register
//    ---------------------------------------------------------
//    |  -   |  -   |  -   |  -   |OCIE0B|OCIE0A| TOIE0|  -   |
//    |  7   |  6   |  5   |  4   |  3   |  2   |  1   |  0   |
//    ---------------------------------------------------------

	TCCR0A = 0b00000000;
//  TCCR0A - Timer/Counter Control Register A
//    ---------------------------------------------------------
//    |COM0A1|COM0A0|COM0B1|COM0B0|     |     | WGM01| WGM00|
//    |  7   |  6   |  5   |  4   |  3   |  2   |  1   |  0   |
//    ---------------------------------------------------------

	TCCR0B = 0b00000101;	//  Fed by System Clock of 9 600 000 divided by 1024 = 9375 Hz
//  TCCR0B - Timer/Counter Control Register B
//    -------------------------------------------------
//    |FOC0A|FOC0B|    |    |WGM02| CS02| CS01| CS00|
//    |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
//    -------------------------------------------------

	TCNT0 = -1;  //  9875 Hz
//	TCNT0 = -3;  //  3125 Hz
//	TCNT0 = -5;  //  1875 Hz
//  TCNT0 - Timer/Counter Register

	ADMUX = 0b00000000;		//  ADC0 (PB5) is input to ADC
//  ADMUX - ADC Multiplexer Selection Register
//    -------------------------------------------------
//    |  -  |REFS0|ADLAR|  -  |  -  |  -  | MUX1| MUX0|
//    |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
//    -------------------------------------------------

	ADCSRA = 0b11001111;	//  Sampling rate is system clock divided by 128
//  ADCSRA - ADC Control and Status Register A
//    -------------------------------------------------
//    |ADEN |ADSC |ADATE| ADIF| ADIE|ADPS2|ADPS1|ADPS0|
//    |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
//    -------------------------------------------------

	DIDR0 = 0b00100000;		//  Disable Digital input buffer on PB5
//  DIDR0 - Digital Input Disable Register 0
//    -------------------------------------------------
//    |    |    |ADC0D|ADC2D|ADC3D|ADC1D|AIN1D|AIN0D|
//    |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
//    -------------------------------------------------

	sei();
//  Global Interrupt Enable -  Sets bit I in SREG

	while(1){ };
	
}


